#!/usr/bin/python
###################################################
# hashdays badge USB picture uploader script 0.3
#
# This script takes a 130x130 pixel color bitmap and converts it for the badge
# and then transmits the data over Serial-USB to the badge
# Windows user might need to install driver from  www.recursion.jp/avrcdc/download.html
# sorry its a quick and dirty script, feel free to improve it

# http://hashdays.ch/badge.html
#############################################################

import serial
import sys
import time
import struct


f=0
lastblock=0x10D0000
counter=0x10D0000
loc_high=13  #0x0d
loc_mid=0
pagecounter=0
checksum=0
blocks=0
datalen=0
oldstr1=''
oldstr2=''
oldstr3=''
oldstr4=''
oldstr5=''
finished=0
printlist=0
testmode=0
pagesize=256
serialport='/dev/tty.usbmodem621'
serialbaud=9600
#serialport='/dev/tty.usbserial-A8008i9k'




def sendbyte(b):
	global pagecounter, checksum, sp, blocks, lastblock, finished, testmode, pagesize
	if (testmode==0):
		sp.write(chr(b))
		sp.flush()
	else:
		print '%d: %s' % (pagecounter, hex(b)) 
	
	pagecounter=pagecounter+1
	checksum=checksum+b
	if pagecounter==pagesize+4:

		if (testmode==0):
			cs = sp.read()
			#print 'checksum received'
			if (len(cs) and ord(cs)==checksum%256):
				blocks = blocks+1
				print '\r<<< Block %d OK at %s (%d,%d)    ' % (blocks, hex(lastblock), ord(cs), checksum%256),
				sys.stdout.flush()
				pagecounter=0
				checksum=0
				lastblock=lastblock+pagesize
				if (finished==0):
					sendbyte(ord('H'))
					sendbyte( int(hex(lastblock)[3:5],base=16) )
					sendbyte( int(hex(lastblock)[5:7],base=16) )
					sendbyte( int(hex(lastblock)[7:9],base=16) )
			else:
				if (len(cs)):
					print '\r*** Error in checksum, resending the block %d %d' % (ord(cs), checksum%256)
				else:
					print '\r*** No checksum received'
				if (finished==0):
					sendbyte(ord('H'))
					sendbyte( int(hex(lastblock)[3:5],base=16) )
					sendbyte( int(hex(lastblock)[5:7],base=16) )
					sendbyte( int(hex(lastblock)[7:9],base=16) )
				pagecounter=0
				checksum=0
			

		
		else:
			blocks = blocks+1
			#print '\r<<< Block %d OK at %s   ' % (blocks, hex(lastblock)),
			pagecounter=0
			checksum=0
			lastblock=lastblock+pagesize
			if (finished==0):
				sendbyte(ord('H'))
				sendbyte( int(hex(lastblock)[3:5],base=16) )
				sendbyte( int(hex(lastblock)[5:7],base=16) )
				sendbyte( int(hex(lastblock)[7:9],base=16) )
					

def handle_badge():
	global serialport, serialbaud, loc_high, loc_mid, sp, checksum, f, counter, pagecounter, datalen, oldstr1, oldstr2, oldstr3, oldstr4, oldstr5, lastblock, blocks, printlist
	datalen=0
	pagecounter=0
	checksum=0
	blocks=0
	waiting=1
	reconnecting=0
	
	#send first address:
	print loc_high,loc_mid, lastblock, counter
	sendbyte(ord('H'))
	sendbyte(loc_high)
	sendbyte(loc_mid)
	sendbyte(0)



def send_end():
	global pagecounter, finished, f, sp, printlist, oldstr1, oldstr2, oldstr3

	while (pagecounter<258):	#padding
		sendbyte(0)
	finished=1
	sendbyte(0)

	#send DONE
	sendbyte(ord('D'))
	sendbyte(ord('O'))
	

	t=time.localtime()
	
	sendbyte(t[2])
	sendbyte(t[1])
	sendbyte(t[0]-2000)
	sendbyte(t[3])
	sendbyte(t[4])
	sendbyte(t[5])

	print
	print '>>> DONE sent.'
	sp.flushInput()
	print '------------------------------------'
	
	f.close()

	finished=0

	sp.close()
	
#main
testmode=0

if (len(sys.argv)<=1):
	print "usage: "+sys.argv[0]+" <picture.bmp> [1-6] [COM PORT]"
	print "   use a 130x130 color bitmap"
	print "   optional specify the location (1-6) where to store the image"
	print "   optional com port like /dev/tty.usbmodem1d11 or COM3"
	exit()

# set the address where to write the picture on the badge
if (len(sys.argv)==3 and sys.argv[2].isdigit()):
	if (sys.argv[2]=='2'):
		lastblock=0x10D8000
		counter=0x10D8000
		loc_high=13  #0x0d
		loc_mid=128  #0x80
	elif (sys.argv[2]=='3'):
		lastblock=0x10E0000
		counter=0x10E0000
		loc_high=14
		loc_mid=0
	elif (sys.argv[2]=='4'):
		lastblock=0x10E8000
		counter=0x10E8000
		loc_high=14
		loc_mid=128  #0x80
	elif (sys.argv[2]=='5'):
		lastblock=0x10F0000
		counter=0x10F0000
		loc_high=15  #0x0d
		loc_mid=0
	elif (sys.argv[2]=='6'):
		lastblock=0x10F8000
		counter=0x10F8000
		loc_high=15
		loc_mid=128  #0x80

#set alternate comport
if (len(sys.argv)==4):
        serialport=sys.argv[3]      

#testmode=1       
if (testmode==0):
	sp = serial.Serial(serialport,serialbaud)
	#sp.timeout = 1


#main
print "reading in bmp file from "+sys.argv[1]

try:
  f = open(sys.argv[1], "rb")
except IOError:
  print "File open failed!"
  exit()
  
try:
	if (f.read(2) <>"BM"):
		print "File is not a BMP, please convert first"
		exit()

        #find pixel offset and width and height
	f.seek(10,0)
	pxloffset_LE = f.read(4)
	pxloffset = struct.unpack('<i', pxloffset_LE)[0]
	f.seek(18,0)
	width_LE = f.read(4)
	width = struct.unpack('<i', width_LE)[0]
	f.seek(22,0)
	height_LE = f.read(4)
	height = struct.unpack('<i', height_LE)[0]

	#must be a 130x130 bmp file
	if (width <>130):
		print "BMP must be exactly 130x130 pixels"
		sys.exit(0)
	if (height <>130):
		print "BMP must be exactly 130x130 pixels"
		sys.exit(0)

	f.seek(pxloffset-2,0)

        #converted image will be stored in here
	data = []

	for h in range(130):
		i=0
		f.read(2)	#skip 2 padding bytes
		for w in range(0,130,2):
			#print h,w
			b1=hex(ord(f.read(1))/16)
			g1=hex(ord(f.read(1))/16)
			r1=hex(ord(f.read(1))/16)
			b2=hex(ord(f.read(1))/16)
			g2=hex(ord(f.read(1))/16)
			r2=hex(ord(f.read(1))/16)

			byte1= r1[2:]+g1[2:]
			byte2= b1[2:]+r2[2:]
			byte3= g2[2:]+b2[2:]
			#print byte1, byte2, byte3

                        #BMP is stored from lower lines to high
			data.insert(i,byte1)
			i=i+1
			data.insert(i,byte2)
			i=i+1
			data.insert(i,byte3)
			i=i+1


	#bmp is now correctly in data list
	
finally:
    f.close()
	
handle_badge() #open serial and tell loader
for databyte in data:   #send the bytes
	counter=counter+1
	datalen=datalen+1
	sendbyte(int(databyte, base=16))
send_end() #send teardown


exit()
	
	


	
	
	
	

